const { test } = require('node:test')
const { ok } = require('node:assert')
const { authUrl } = require('../src/oauth')

process.env.GOOGLE_OAUTH_CLIENT_ID = process.env.GOOGLE_OAUTH_CLIENT_ID || 'dummy'
process.env.GOOGLE_OAUTH_CLIENT_SECRET = process.env.GOOGLE_OAUTH_CLIENT_SECRET || 'dummy'
process.env.GOOGLE_OAUTH_REDIRECT_URI = process.env.GOOGLE_OAUTH_REDIRECT_URI || 'http://localhost:3000/oauth/google/callback'

test('auth url contains redirect', () => {
  const url = authUrl(['email'], 'state')
  ok(url.includes('oauth2'))
})
