const { google } = require('googleapis')
const { getOauth2Client } = require('./oauth')
const { upsertOauthToken } = require('./db')

async function withGoogle(userId, fn) {
  const oauth2Client = getOauth2Client(userId)
  oauth2Client.on('tokens', t => {
    const payload = {
      scope: t.scope || null,
      access_token: t.access_token || null,
      refresh_token_enc: t.refresh_token ? require('./crypto').encrypt(t.refresh_token) : undefined,
      token_type: t.token_type || 'Bearer',
      expiry_date: t.expiry_date || null,
      revoked_at: null
    }
    upsertOauthToken(userId, 'google', payload)
  })
  oauth2Client.on('error', err => {
    console.error('[Google] OAuth client error:', { userId, error: err.message })
  })
  const gmail = google.gmail({ version: 'v1', auth: oauth2Client })
  const drive = google.drive({ version: 'v3', auth: oauth2Client })
  return fn({ oauth2Client, gmail, drive })
}

module.exports = { withGoogle }
