const crypto = require('crypto')

function getKey() {
  const key = process.env.TOKEN_ENCRYPTION_KEY || ''
  if (!key || key.length < 32) throw new Error('invalid_encryption_key')
  return Buffer.from(key.slice(0, 32))
}

function encrypt(text) {
  const key = getKey()
  const iv = crypto.randomBytes(12)
  const cipher = crypto.createCipheriv('aes-256-gcm', key, iv)
  const enc = Buffer.concat([cipher.update(text, 'utf8'), cipher.final()])
  const tag = cipher.getAuthTag()
  return Buffer.concat([iv, tag, enc]).toString('base64')
}

function decrypt(b64) {
  const key = getKey()
  const buf = Buffer.from(b64, 'base64')
  const iv = buf.slice(0, 12)
  const tag = buf.slice(12, 28)
  const data = buf.slice(28)
  const decipher = crypto.createDecipheriv('aes-256-gcm', key, iv)
  decipher.setAuthTag(tag)
  const dec = Buffer.concat([decipher.update(data), decipher.final()])
  return dec.toString('utf8')
}

module.exports = { encrypt, decrypt }
