let accessToken = ''

function init() {
  google.accounts.id.initialize({ client_id: window.GOOGLE_OAUTH_CLIENT_ID || '', callback: handleCredentialResponse })
  google.accounts.id.renderButton(document.getElementById('signin'), { theme: 'outline', size: 'large' })
  document.getElementById('connect').addEventListener('click', connectScopes)
  document.getElementById('uploadBtn').addEventListener('click', uploadFile)
}

function handleCredentialResponse(resp) {
  fetch('/auth/google', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ idToken: resp.credential }) })
    .then(r => r.json())
    .then(data => {
      if (data.error) {
        alert('Authentication failed: ' + (data.error === 'organization_access_denied' ? 'Access restricted to specific organization users. Please contact your administrator.' : 'Invalid Google token'))
        return
      }
      accessToken = data.accessToken
      document.getElementById('connect').disabled = false
      loadInbox()
      loadFiles()
    })
    .catch(err => {
      console.error('Auth error:', err)
      alert('Authentication failed. Please check your Google account settings and try again.')
    })
}

function authHeaders() { return { Authorization: 'Bearer ' + accessToken } }

function connectScopes() {
  fetch('/oauth/google/start', { headers: authHeaders() })
    .then(r => r.json())
    .then(d => { window.location.href = d.url })
}

function loadInbox() {
  fetch('/gmail/messages', { headers: authHeaders() })
    .then(r => r.json())
    .then(d => {
      const parent = document.getElementById('messages')
      parent.innerHTML = ''
      (d.messages || []).forEach(m => {
        const subject = (m.payload.headers.find(h => h.name === 'Subject') || {}).value || ''
        const from = (m.payload.headers.find(h => h.name === 'From') || {}).value || ''
        const el = document.createElement('div')
        el.className = 'border p-2 mb-1'
        el.textContent = subject + ' — ' + from
        parent.appendChild(el)
      })
    })
}

function loadFiles() {
  fetch('/drive/files', { headers: authHeaders() })
    .then(r => r.json())
    .then(d => {
      const parent = document.getElementById('files')
      parent.innerHTML = ''
      ;(d.files || []).forEach(f => {
        const el = document.createElement('div')
        el.className = 'border p-2 mb-1'
        el.textContent = f.name + ' (' + f.mimeType + ')'
        parent.appendChild(el)
      })
    })
}

function uploadFile() {
  const input = document.getElementById('uploadFile')
  if (!input.files.length) return
  const fd = new FormData()
  fd.append('file', input.files[0])
  fetch('/drive/upload', { method: 'POST', headers: authHeaders(), body: fd })
    .then(r => r.json())
    .then(() => loadFiles())
}

window.addEventListener('load', init)
