# Network / Firewall Organization Boundary Notes

## Current Setup
- App runs on `localhost:3000` (development)
- Google OAuth endpoints: `accounts.google.com`, `oauth2.googleapis.com`
- Gmail API: `gmail.googleapis.com`
- Drive API: `www.googleapis.com`, `drive.googleapis.com`

## Organization Restrictions
- Google Workspace admin can set **API access controls**:
  - Allow only specific client IDs
  - Restrict OAuth scopes per OU
  - Require admin approval for new apps

## Firewall Considerations
If deploying behind corporate proxy/firewall:
- Whitelist Google OAuth and API domains above
- Ensure outbound 443 (HTTPS) is open
- Consider **domain restriction headers** if proxy supports URL filtering

## Cross-Org Scenarios
Current implementation blocks cross-org by design. If needed:
- Use **service account + domain-wide delegation** instead of user OAuth
- Maintain separate auth flow for external users with audit logging
- Implement **session isolation** to prevent data leakage between orgs

## Security Headers
Consider adding for defense-in-depth:
```
Content-Security-Policy: frame-ancestors 'none'
X-Frame-Options: DENY
Strict-Transport-Security: max-age=31536000; includeSubDomains
```

## Monitoring
- Log all OAuth consent events in Google Admin console
- Monitor firewall blocks for Google domains (indicates misconfig)
- Alert on unusual geographic or device patterns