# Cross-Organization Authentication Delegation Guide

## Current Status
By default the app enforces single-organization access via `ALLOWED_ORGANIZATION` environment variable. Cross-org access is **disabled** to prevent data leakage.

## When to Enable
Only if business requirement mandates multi-tenant or external partner access.

## Recommended Approach: Service Account + Domain-Wide Delegation
1. Create a **Google service account** in your Google Cloud project
2. Enable **Domain-wide delegation** in Google Workspace Admin console
3. Grant service account required OAuth scopes:
   - `https://www.googleapis.com/auth/gmail.modify`
   - `https://www.googleapis.com/auth/drive`
4. Store service account JSON key securely (encrypted at rest)
5. Implement separate auth flow:
   - External users authenticate via OIDC/SAML to your IdP
   - Your backend uses service account to impersonate their Google identity
   - Maintain audit log of impersonation events

## Implementation Steps
1. Add environment variable:
   ```
   GOOGLE_SERVICE_ACCOUNT_KEY_PATH=./keys/service-account.json
   ALLOW_CROSS_ORG=true
   ```
2. Create new auth middleware that:
   - Validates external user via your IdP
   - Uses service account to impersonate Google user
   - Stores impersonation audit record
3. Update UI to show external user badge/warning
4. Add rate limiting per external domain

## Security Considerations
- **Never store external user Google tokens** – always use impersonation
- **Audit every impersonation** with: timestamp, external user, target Google user, action
- **Limit scopes** to minimum required for business function
- **Implement session timeout** for external users (shorter than internal)
- **Regular access reviews** – disable external access if unused > 30 days

## Alternative: Explicit Domain Whitelist
If full delegation is too broad:
1. Maintain whitelist of allowed external domains in database
2. Require admin approval for each external domain
3. Implement additional MFA for external users
4. Restrict access to specific shared drives or Gmail labels only

## Monitoring
- Alert on first-time external domain access
- Monitor volume of impersonation calls
- Track data export/download events by external users
- Set up anomaly detection for unusual access patterns