# Google Mail + Drive Web App

## Overview
This app provides Google OAuth 2.0 authentication and integrates Gmail and Google Drive for end-to-end email and file management.

## Environment
- `GOOGLE_OAUTH_CLIENT_ID`
- `GOOGLE_OAUTH_CLIENT_SECRET`
- `GOOGLE_OAUTH_REDIRECT_URI` (e.g. `http://localhost:3000/oauth/google/callback`)
- `APP_JWT_SECRET`
- `TOKEN_ENCRYPTION_KEY` (32 chars)

## Authentication Flow
```mermaid
sequenceDiagram
  participant User
  participant Frontend
  participant Backend
  participant Google
  User->>Frontend: Google Sign-In
  Frontend->>Backend: POST /auth/google (idToken)
  Backend->>Google: verify idToken
  Google-->>Backend: payload
  Backend->>Frontend: JWT
  User->>Frontend: Click Connect Gmail + Drive
  Frontend->>Backend: GET /oauth/google/start (JWT)
  Backend->>Google: Generate Auth URL (offline)
  Frontend->>Google: Redirect to consent
  Google->>Backend: GET /oauth/google/callback?code&state
  Backend->>Backend: verify state (JWT)
  Backend->>Google: exchange code for tokens
  Backend->>DB: store encrypted refresh token
  Backend-->>Frontend: ok
```

## APIs
- `GET /health`
- `POST /auth/google` { idToken }
- `GET /me`
- `GET /oauth/google/start`
- `GET /oauth/google/callback`
- Gmail:
  - `GET /gmail/labels`
  - `GET /gmail/messages?q=&labelIds=&pageToken=`
  - `GET /gmail/messages/:id`
  - `POST /gmail/messages/:id/delete`
  - `POST /gmail/messages/:id/archive`
  - `POST /gmail/send` { to, subject, body, cc?, bcc?, contentType? }
- Drive:
  - `GET /drive/files?q=&pageToken=&pageSize=`
  - `GET /drive/files/:id`
  - `GET /drive/files/:id/download`
  - `POST /drive/upload` (multipart `file`, `parent?`, `name?`)
  - `POST /drive/files` { name, mimeType?, parent? }
  - `DELETE /drive/files/:id`
  - `POST /drive/files/:id/permissions` { type, role, emailAddress }

## Error Handling
- Rate limits return `429`
- Auth failures return `401`
- General failures return `500`
- Responses include `{ error }`

## Token Management
- Refresh tokens encrypted with AES-256-GCM
- Auto refresh via Google client `tokens` event persists updates
- Revocation handled by marking `revoked_at` and requiring reconnection

## Deployment
- Set environment variables
- `npm install`
- `npm start`
- Expose `public/` and configure redirect URI

## Testing
- `npm test` uses Node `--test` for basic encryption and OAuth URL checks
